package gov.va.med.mhv.integration.phr.transfer;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * User: Rob Murtha
 */
public class FacilityExtractStatus implements Serializable {

    private static final long serialVersionUID = -1253951220478378598L;
    /** patient identifier */
    private String icn;

    /** facility identifier */
    private String stationNumber;

    /** extract extract represented */
    private String extract;

    /** date of most recently added or updated record */
    private Date lastModified;

    /** number of records retrieved when lastModified */
    private long recordCount;
    
    /** number of retries required for successful refresh */
    @JsonIgnore
    private long retryCount;

    /** date of most recent request */
    private Date lastRequested;

    /** date of most recent request completed regardless of modifications */
    private Date lastCompleted;
    
    /** the status of the latest load operation (e.g. 'OK' or 'ERROR') */
    private String loadStatus;
    
    /** if there is an error message associated with the last load operation, it is included here. */
    private String errorMessage;

    /** if an error occurred indicate the last successful refresh*/
    private Date lastSuccessfulCompleted;
    
    /** indicates that the last requested refresh has completed
     * @return boolean
     */
    public boolean isUpToDate() {
    	long lastRequested = (getLastRequested() != null) ? getLastRequested().getTime() : 0L;
    	long lastCompleted = (getLastCompleted() != null) ? getLastCompleted().getTime() : 0L;
    	return lastCompleted > lastRequested;
    }
    
    public boolean inProgress() {
    	// A extract that is in progress should have a last requested date greater than last completed date
    	long lastRequested = (getLastRequested() != null) ? getLastRequested().getTime() : 0L;
    	long lastCompleted = (getLastCompleted() != null) ? getLastCompleted().getTime() : 0L;
    	return lastRequested > lastCompleted;    	
    }

    public String getIcn() {
        return this.icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    /** The station number associated with the facility for this refresh */
    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    /** The type of extract data requested */
    public String getExtract() {
        return extract;
    }

    public void setExtract(String extract) {
        this.extract = extract;
    }

    /** the last date when records were added or modified in evault */
    public Date getLastModified() {
        return lastModified;
    }

    /** the number of records added or modified from this facility or extract type */
    public long getRecordCount() {
        return recordCount;
    }

    public void setRecordCount(long recordCount) {
        this.recordCount = recordCount;
    }   
    
    public long getRetryCount() {
		return retryCount;
	}

	public void setRetryCount(long retryCount) {
		this.retryCount = retryCount;
	}

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    /** the last date when records were requested */
    public Date getLastRequested() {
        return lastRequested;
    }

    public void setLastRequested(Date lastRequested) {
        this.lastRequested = lastRequested;
    }

    /** the last date when a refresh was completed may be different then lastModified of 0 records were returned */
    public Date getLastCompleted() {
        return lastCompleted;
    }

    public void setLastCompleted(Date lastCompleted) {
        this.lastCompleted = lastCompleted;
    }
    
    public String getLoadStatus() {
		return loadStatus;
	}
    
    public void setLoadStatus(String loadStatus) {
		this.loadStatus = loadStatus;
	}
    
    public String getErrorMessage() {
		return errorMessage;
	}
    
    public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

    public Date getLastSuccessfulCompleted() {
		return lastSuccessfulCompleted;
	}

	public void setLastSuccessfulCompleted(Date lastSuccessfulCompleted) {
		this.lastSuccessfulCompleted = lastSuccessfulCompleted;
	}

	@Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof FacilityExtractStatus)) return false;

        FacilityExtractStatus that = (FacilityExtractStatus) o;

        if (recordCount != that.recordCount) return false;
        if (extract != null ? !extract.equals(that.extract) : that.extract != null) return false;
        if (icn != null ? !icn.equals(that.icn) : that.icn != null) return false;
        if (lastCompleted != null ? !lastCompleted.equals(that.lastCompleted) : that.lastCompleted != null)
            return false;
        if (lastModified != null ? !lastModified.equals(that.lastModified) : that.lastModified != null) return false;
        if (lastRequested != null ? !lastRequested.equals(that.lastRequested) : that.lastRequested != null)
            return false;
        if (stationNumber != null ? !stationNumber.equals(that.stationNumber) : that.stationNumber != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + (icn != null ? icn.hashCode() : 0);
        result = 31 * result + (stationNumber != null ? stationNumber.hashCode() : 0);
        result = 31 * result + (extract != null ? extract.hashCode() : 0);
        result = 31 * result + (lastModified != null ? lastModified.hashCode() : 0);
        result = 31 * result + (lastRequested != null ? lastRequested.hashCode() : 0);
        result = 31 * result + (lastCompleted != null ? lastCompleted.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "FacilityExtractStatus{" +
                "icn='" + icn + '\'' +
                ", stationNumber='" + stationNumber + '\'' +
                ", extract='" + extract + '\'' +
                ", lastModified=" + lastModified +
                ", recordCount=" + recordCount +
                ", lastRequested=" + lastRequested +
                ", lastCompleted=" + lastCompleted +
                ", loadStatus=" + loadStatus +
                ((errorMessage != null) ? ", errorMessage=" + errorMessage : "") +
                '}';
    }
    
}
